/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.bearing;

import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.bearing.IBearingBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.OrientedRotatingVisual;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.visual.DynamicVisual;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.OrientedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.visual.SimpleDynamicVisual;
import java.util.function.Consumer;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class BearingVisual<B extends KineticBlockEntity>
extends OrientedRotatingVisual<B>
implements SimpleDynamicVisual {
    final OrientedInstance topInstance;
    final Axis rotationAxis;
    final Quaternionf blockOrientation;

    public BearingVisual(VisualizationContext context, B blockEntity, float partialTick) {
        super(context, blockEntity, partialTick, Direction.SOUTH, ((Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_(), Models.partial((PartialModel)AllPartialModels.SHAFT_HALF));
        Direction facing = (Direction)this.blockState.m_61143_((Property)BlockStateProperties.f_61372_);
        this.rotationAxis = Axis.m_253057_((Vector3f)Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)this.rotationAxis()).m_253071_());
        this.blockOrientation = BearingVisual.getBlockStateOrientation(facing);
        PartialModel top = ((IBearingBlockEntity)blockEntity).isWoodenTop() ? AllPartialModels.BEARING_TOP_WOODEN : AllPartialModels.BEARING_TOP;
        this.topInstance = (OrientedInstance)this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial((PartialModel)top)).createInstance();
        this.topInstance.position((Vec3i)this.getVisualPosition()).rotation((Quaternionfc)this.blockOrientation).setChanged();
    }

    public void beginFrame(DynamicVisual.Context ctx) {
        float interpolatedAngle = ((IBearingBlockEntity)((Object)((KineticBlockEntity)this.blockEntity))).getInterpolatedAngle(ctx.partialTick() - 1.0f);
        Quaternionf rot = this.rotationAxis.m_252977_(interpolatedAngle);
        rot.mul((Quaternionfc)this.blockOrientation);
        this.topInstance.rotation((Quaternionfc)rot).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(new FlatLit[]{this.topInstance});
    }

    @Override
    protected void _delete() {
        super._delete();
        this.topInstance.delete();
    }

    static Quaternionf getBlockStateOrientation(Direction facing) {
        Quaternionf orientation = facing.m_122434_().m_122479_() ? Axis.f_252436_.m_252977_(AngleHelper.horizontalAngle((Direction)facing.m_122424_())) : new Quaternionf();
        orientation.mul((Quaternionfc)Axis.f_252529_.m_252977_(-90.0f - AngleHelper.verticalAngle((Direction)facing)));
        return orientation;
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept((Instance)this.topInstance);
    }
}

