/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.GumbeeperModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.entity.CustomBookEntityRenderer;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.GumbeeperEnergySwirlLayer;
import com.github.alexmodguy.alexscaves.client.render.entity.layer.LicowitchPossessionLayer;
import com.github.alexmodguy.alexscaves.server.entity.living.GumbeeperEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class GumbeeperRenderer
extends MobRenderer<GumbeeperEntity, GumbeeperModel>
implements CustomBookEntityRenderer {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/gumbeeper.png");
    private static final ResourceLocation TEXTURE_GLASS = new ResourceLocation("alexscaves:textures/entity/gumbeeper_glass.png");
    private static final ResourceLocation TEXTURE_EXPLODE = new ResourceLocation("alexscaves:textures/entity/gumbeeper_explode.png");
    private static final ResourceLocation TEXTURE_POSSESSED = new ResourceLocation("alexscaves:textures/entity/gumbeeper_possessed.png");
    private boolean sepia = false;

    public GumbeeperRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new GumbeeperModel(0.0f), 0.8f);
        this.m_115326_(new LayerGlow());
        this.m_115326_((RenderLayer)new GumbeeperEnergySwirlLayer((RenderLayerParent<GumbeeperEntity, GumbeeperModel>)this));
        this.m_115326_(new LicowitchPossessionLayer(this, gumbeeperEntity -> TEXTURE_EXPLODE));
    }

    protected void scale(GumbeeperEntity mob, PoseStack poseStack, float partialTicks) {
    }

    public ResourceLocation getTextureLocation(GumbeeperEntity entity) {
        return TEXTURE;
    }

    @Override
    public void setSepiaFlag(boolean sepiaFlag) {
        this.sepia = sepiaFlag;
    }

    @Nullable
    protected RenderType getRenderType(GumbeeperEntity deepOneMageEntity, boolean normal, boolean translucent, boolean outline) {
        ResourceLocation resourcelocation = this.getTextureLocation(deepOneMageEntity);
        if (translucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (normal) {
            return this.sepia ? ACRenderTypes.getBookWidget(resourcelocation, true) : RenderType.m_110458_((ResourceLocation)resourcelocation);
        }
        return outline ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    class LayerGlow
    extends RenderLayer<GumbeeperEntity, GumbeeperModel> {
        public LayerGlow() {
            super((RenderLayerParent)GumbeeperRenderer.this);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, GumbeeperEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(GumbeeperRenderer.this.sepia ? ACRenderTypes.getBookWidget(TEXTURE_GLASS, true) : RenderType.m_110470_((ResourceLocation)TEXTURE_GLASS));
            ((GumbeeperModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            float explodeProgress = entitylivingbaseIn.getExplodeProgress(partialTicks);
            float alpha = (float)(Math.sin(ageInTicks * 1.2f) + 1.0) * 0.5f * explodeProgress * 0.8f;
            VertexConsumer ivertexbuilder4 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_EXPLODE));
            ((GumbeeperModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder4, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, alpha);
        }
    }
}

