/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.ClientProxy;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.item.SugarStaffHexEntity;
import com.github.alexthe666.citadel.client.shader.PostEffectRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class SugarStaffHexRenderer
extends EntityRenderer<SugarStaffHexEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves", "textures/entity/sugar_staff_hex.png");

    public SugarStaffHexRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SugarStaffHexEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int packedLight) {
        float minAge;
        PostEffectRegistry.renderEffectForNextTick((ResourceLocation)ClientProxy.PURPLE_WITCH_SHADER);
        poseStack.m_85836_();
        float despawnsIn = entity.getDespawnTime(partialTicks);
        float randomRotation = entity.m_19879_() % 4 * 90;
        float randomYOffset = entity.getYRenderOffset();
        float tickCount = (float)entity.f_19797_ + partialTicks;
        float alpha = minAge = Math.min(1.0f, Math.min(tickCount, despawnsIn) / 10.0f);
        float alpha2 = alpha * alpha;
        float scale = 4.0f * entity.getHexScale();
        poseStack.m_252880_(0.0f, randomYOffset, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(randomRotation + 3.0f * tickCount));
        poseStack.m_85841_(scale, scale, scale);
        SugarStaffHexRenderer.renderHex(poseStack, multiBufferSource, ACRenderTypes.getPurpleWitch(TEXTURE), 1.0f, 1.0f, 1.0f - alpha2, 1.0f);
        for (int i = 0; i < 5; ++i) {
            float f = (1.0f - (float)i / 5.0f) * 0.5f;
            float bob = (float)(Math.sin(tickCount * 0.2f + (float)i) * (double)0.005f);
            SugarStaffHexRenderer.renderHex(poseStack, multiBufferSource, ACRenderTypes.getVoidBeingCloud(TEXTURE), 1.0f * f, 1.0f, 1.0f - alpha2 * f, 1.0f);
            poseStack.m_252880_(0.0f, 0.01f + bob + (1.0f - alpha2) * 0.03f, 0.0f);
        }
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, multiBufferSource, packedLight);
    }

    public static void renderHex(PoseStack poseStack, MultiBufferSource multiBufferSource, RenderType renderType, float alpha, float r, float g, float b) {
        PoseStack.Pose posestack$pose = poseStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(renderType);
        SugarStaffHexRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 240, 0.0f, 0, 0, 1, alpha, r, g, b);
        SugarStaffHexRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 240, 1.0f, 0, 1, 1, alpha, r, g, b);
        SugarStaffHexRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 240, 1.0f, 1, 1, 0, alpha, r, g, b);
        SugarStaffHexRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 240, 0.0f, 1, 0, 0, alpha, r, g, b);
    }

    private static void vertex(VertexConsumer vertexConsumer, Matrix4f matrix4f, Matrix3f matrix3f, int p_253829_, float x, int y, int u, int v, float alpha, float r, float g, float b) {
        vertexConsumer.m_252986_(matrix4f, x - 0.5f, 0.01f, (float)y - 0.5f).m_85950_(r, g, b, alpha).m_7421_((float)u, (float)v).m_86008_(OverlayTexture.f_118083_).m_85969_(p_253829_).m_252939_(matrix3f, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public ResourceLocation getTextureLocation(SugarStaffHexEntity gumballEntity) {
        return TEXTURE;
    }
}

