/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.living.TremorzillaEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class TremorzillaFollowOwnerGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = 32;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final TremorzillaEntity tremorzilla;
    private LivingEntity owner;
    private final LevelReader level;
    private final double speedModifier;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;

    public TremorzillaFollowOwnerGoal(TremorzillaEntity tremorzilla, double speed, float minDist, float maxDist) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.tremorzilla = tremorzilla;
        this.level = tremorzilla.m_9236_();
        this.speedModifier = speed;
        this.startDistance = minDist;
        this.stopDistance = maxDist;
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.tremorzilla.m_269323_();
        if (this.tremorzilla.getCommand() != 2) {
            return false;
        }
        if (livingentity == null) {
            return false;
        }
        if (livingentity.m_5833_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.tremorzilla.m_20280_((Entity)livingentity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        if (this.isInCombat()) {
            return false;
        }
        this.owner = livingentity;
        return true;
    }

    public boolean m_8045_() {
        if (this.tremorzilla.getCommand() != 2) {
            return false;
        }
        if (this.tremorzilla.m_21573_().m_26571_()) {
            return false;
        }
        if (this.unableToMove()) {
            return false;
        }
        if (this.isInCombat()) {
            return false;
        }
        return !(this.tremorzilla.m_20280_((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    private boolean unableToMove() {
        return this.tremorzilla.m_21827_() || this.tremorzilla.m_20159_() || this.tremorzilla.m_21523_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
    }

    public void m_8041_() {
        this.owner = null;
        this.tremorzilla.m_21573_().m_26573_();
    }

    public void m_8037_() {
        this.tremorzilla.m_21563_().m_24960_((Entity)this.owner, 10.0f, (float)this.tremorzilla.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.tremorzilla.m_20280_((Entity)this.owner) >= 1024.0 && ((Boolean)AlexsCaves.COMMON_CONFIG.devastatingTremorzillaBeam.get()).booleanValue()) {
                this.teleportToOwner();
            } else {
                this.tremorzilla.m_21573_().m_5624_((Entity)this.owner, this.speedModifier);
            }
        }
    }

    private void teleportToOwner() {
        BlockPos blockpos = this.owner.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-10, 10);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-10, 10);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return;
        }
    }

    private boolean isInCombat() {
        LivingEntity owner = this.tremorzilla.m_269323_();
        if (owner != null) {
            return this.tremorzilla.m_20270_((Entity)owner) < 50.0f && this.tremorzilla.m_5448_() != null && this.tremorzilla.m_5448_().m_6084_();
        }
        return false;
    }

    private boolean maybeTeleportTo(int x, int y, int z) {
        if (Math.abs((double)x - this.owner.m_20185_()) < 6.0 && Math.abs((double)z - this.owner.m_20189_()) < 6.0) {
            return false;
        }
        if (!this.canTeleportTo(new BlockPos(x, y, z))) {
            return false;
        }
        this.tremorzilla.m_7678_((double)x + 0.5, y, (double)z + 0.5, this.tremorzilla.m_146908_(), this.tremorzilla.m_146909_());
        this.tremorzilla.m_21573_().m_26573_();
        return true;
    }

    private boolean canTeleportTo(BlockPos blockPos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.level, (BlockPos.MutableBlockPos)blockPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = blockPos.m_121996_((Vec3i)this.tremorzilla.m_20183_());
        return this.level.m_45756_((Entity)this.tremorzilla, this.tremorzilla.m_20191_().m_82338_(blockpos));
    }

    private int randomIntInclusive(int i, int j) {
        return this.tremorzilla.m_217043_().m_188503_(j - i + 1) + i;
    }
}

