/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.entity.living.VesperEntity;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class VesperFlyAndHangGoal
extends Goal {
    private VesperEntity entity;
    private boolean wantsToHang = false;
    private double x;
    private double y;
    private double z;
    private int hangCheckIn = 0;

    public VesperFlyAndHangGoal(VesperEntity entity) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.entity = entity;
    }

    public boolean m_8036_() {
        if (this.entity.m_20160_() || this.entity.m_5448_() != null && this.entity.m_5448_().m_6084_() || this.entity.m_20159_()) {
            return false;
        }
        if (this.entity.isHanging() || this.entity.groundedFor > 0) {
            return false;
        }
        if (!this.entity.isFlying() && this.entity.m_217043_().m_188503_(70) != 0) {
            return false;
        }
        this.wantsToHang = this.entity.timeFlying > 300;
        Vec3 target = this.getPosition();
        if (target == null) {
            return false;
        }
        this.x = target.f_82479_;
        this.y = target.f_82480_;
        this.z = target.f_82481_;
        return true;
    }

    private Vec3 getPosition() {
        Vec3 hangPos;
        if (this.wantsToHang && (hangPos = this.findHangFromPos()) != null) {
            return hangPos;
        }
        return this.findFlightPos();
    }

    public void m_8056_() {
        this.entity.setFlying(true);
        this.entity.setHanging(false);
        this.hangCheckIn = 0;
        this.entity.m_21573_().m_26519_(this.x, this.y, this.z, 1.0);
    }

    public void m_8037_() {
        if (this.wantsToHang && this.hangCheckIn-- < 0) {
            this.hangCheckIn = 5 + this.entity.m_217043_().m_188503_(5);
            if (!this.entity.isHanging() && this.entity.canHangFrom(this.entity.posAbove(), this.entity.m_9236_().m_8055_(this.entity.posAbove()))) {
                this.entity.setHanging(true);
                this.entity.setFlying(false);
            }
        }
        if (this.entity.isFlying() && this.entity.m_20096_() && this.entity.timeFlying > 40) {
            this.entity.setFlying(false);
        }
    }

    public boolean m_8045_() {
        if (this.wantsToHang) {
            return !this.entity.m_21573_().m_26571_() && !this.entity.isHanging() && this.entity.groundedFor <= 0;
        }
        return this.entity.isFlying() && !this.entity.m_21573_().m_26571_() && this.entity.groundedFor <= 0;
    }

    public void m_8041_() {
        if (this.wantsToHang) {
            this.entity.m_21573_().m_26573_();
        }
        this.wantsToHang = false;
    }

    private Vec3 findFlightPos() {
        int range = 13;
        Vec3 heightAdjusted = this.entity.m_20182_().m_82520_((double)(this.entity.m_217043_().m_188503_(range * 2) - range), 0.0, (double)(this.entity.m_217043_().m_188503_(range * 2) - range));
        if (this.entity.m_9236_().m_45527_(BlockPos.m_274446_((Position)heightAdjusted))) {
            ground = this.groundPosition(heightAdjusted);
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + 4.0 + (double)this.entity.m_217043_().m_188503_(3), heightAdjusted.f_82481_);
        } else {
            ground = this.groundPosition(heightAdjusted);
            BlockPos ceiling = BlockPos.m_274446_((Position)ground).m_6630_(2);
            while (ceiling.m_123342_() < this.entity.m_9236_().m_151558_() && !this.entity.m_9236_().m_8055_(ceiling).m_280296_()) {
                ceiling = ceiling.m_7494_();
            }
            float randCeilVal = 0.3f + this.entity.m_217043_().m_188501_() * 0.5f;
            heightAdjusted = new Vec3(heightAdjusted.f_82479_, ground.f_82480_ + ((double)ceiling.m_123342_() - ground.f_82480_) * (double)randCeilVal, heightAdjusted.f_82481_);
        }
        BlockHitResult result = this.entity.m_9236_().m_45547_(new ClipContext(this.entity.m_146892_(), heightAdjusted, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        if (result.m_6662_() == HitResult.Type.MISS) {
            return heightAdjusted;
        }
        return result.m_82450_();
    }

    private boolean isOverWaterOrVoid() {
        BlockPos position = this.entity.m_20183_();
        while (position.m_123342_() > this.entity.m_9236_().m_141937_() && this.entity.m_9236_().m_46859_(position)) {
            position = position.m_7495_();
        }
        return !this.entity.m_9236_().m_6425_(position).m_76178_() || this.entity.m_9236_().m_8055_(position).m_60713_(Blocks.f_50191_) || position.m_123342_() <= this.entity.m_9236_().m_141937_();
    }

    public Vec3 groundPosition(Vec3 airPosition) {
        BlockPos.MutableBlockPos ground = new BlockPos.MutableBlockPos();
        ground.m_122169_(airPosition.f_82479_, airPosition.f_82480_, airPosition.f_82481_);
        boolean flag = false;
        while (ground.m_123342_() < this.entity.m_9236_().m_151558_() && !this.entity.m_9236_().m_8055_((BlockPos)ground).m_280296_() && this.entity.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
            ground.m_122184_(0, 1, 0);
            flag = true;
        }
        ground.m_122184_(0, -1, 0);
        while (ground.m_123342_() > this.entity.m_9236_().m_141937_() && !this.entity.m_9236_().m_8055_((BlockPos)ground).m_280296_() && this.entity.m_9236_().m_6425_((BlockPos)ground).m_76178_()) {
            ground.m_122184_(0, -1, 0);
        }
        return Vec3.m_82512_((Vec3i)(flag ? ground.m_7494_() : ground.m_7495_()));
    }

    public Vec3 findHangFromPos() {
        BlockPos blockpos = null;
        Random random = new Random();
        int range = 14;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockpos1 = this.entity.m_20183_().m_7918_(random.nextInt(range) - range / 2, 0, random.nextInt(range) - range / 2);
            if (!this.entity.m_9236_().m_46859_(blockpos1) || !this.entity.m_9236_().m_46749_(blockpos1)) continue;
            while (this.entity.m_9236_().m_46859_(blockpos1) && blockpos1.m_123342_() < this.entity.m_9236_().m_151558_()) {
                blockpos1 = blockpos1.m_7494_();
            }
            if (!((double)blockpos1.m_123342_() > this.entity.m_20186_() - 1.0) || !this.entity.canHangFrom(blockpos1, this.entity.m_9236_().m_8055_(blockpos1)) || !this.hasLineOfToPos(blockpos1)) continue;
            blockpos = blockpos1;
        }
        return blockpos == null ? null : Vec3.m_82512_(blockpos);
    }

    public boolean hasLineOfToPos(BlockPos in) {
        BlockHitResult raytraceresult = this.entity.m_9236_().m_45547_(new ClipContext(this.entity.m_20299_(1.0f), new Vec3((double)in.m_123341_() + 0.5, (double)in.m_123342_() + 0.5, (double)in.m_123343_() + 0.5), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.entity));
        if (raytraceresult instanceof BlockHitResult) {
            BlockHitResult blockRayTraceResult = raytraceresult;
            BlockPos pos = blockRayTraceResult.m_82425_();
            return pos.equals((Object)in) || this.entity.m_9236_().m_46859_(pos);
        }
        return true;
    }
}

