/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.feature;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.block.LicorootVineBlock;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.github.alexmodguy.alexscaves.server.misc.ACTagRegistry;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class LicorootTreeFeature
extends Feature<NoneFeatureConfiguration> {
    private static final Map<Direction, Direction[]> SPIRAL_UP_MAP = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Direction.NORTH, new Direction[]{Direction.NORTH, Direction.UP, Direction.SOUTH, Direction.DOWN});
        map.put(Direction.SOUTH, new Direction[]{Direction.SOUTH, Direction.UP, Direction.NORTH, Direction.DOWN});
        map.put(Direction.EAST, new Direction[]{Direction.EAST, Direction.UP, Direction.WEST, Direction.DOWN});
        map.put(Direction.WEST, new Direction[]{Direction.WEST, Direction.UP, Direction.EAST, Direction.DOWN});
    });
    private static final Map<Direction, Direction[]> SPIRAL_DOWN_MAP = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(Direction.NORTH, new Direction[]{Direction.NORTH, Direction.DOWN, Direction.SOUTH, Direction.UP});
        map.put(Direction.SOUTH, new Direction[]{Direction.SOUTH, Direction.DOWN, Direction.NORTH, Direction.UP});
        map.put(Direction.EAST, new Direction[]{Direction.EAST, Direction.DOWN, Direction.WEST, Direction.UP});
        map.put(Direction.WEST, new Direction[]{Direction.WEST, Direction.DOWN, Direction.EAST, Direction.UP});
    });

    public LicorootTreeFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        int centerAboveGround;
        int height;
        BlockPos treeGround;
        RandomSource randomsource = context.m_225041_();
        WorldGenLevel level = context.m_159774_();
        if (!this.checkCanTreePlace(level, treeGround = context.m_159777_(), height = (centerAboveGround = 5 + randomsource.m_188503_(5)) + 4 + randomsource.m_188503_(7))) {
            return false;
        }
        BlockPos centerPos = treeGround.m_6630_(centerAboveGround);
        for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
            if (!randomsource.m_188499_()) continue;
            BlockPos extraTrunkPos = centerPos.m_121945_(direction).m_5484_(Direction.DOWN, randomsource.m_188503_(1) + 1);
            for (int trunkLengths = 0; LicorootTreeFeature.canReplace(level.m_8055_(extraTrunkPos)) && trunkLengths < centerAboveGround + 2; ++trunkLengths) {
                level.m_7731_(extraTrunkPos, ((Block)ACBlockRegistry.LICOROOT.get()).m_49966_(), 3);
                extraTrunkPos = extraTrunkPos.m_7495_();
            }
        }
        for (int centerHeight = 0; centerHeight < height; ++centerHeight) {
            level.m_7731_(treeGround, ((Block)ACBlockRegistry.LICOROOT.get()).m_49966_(), 3);
            treeGround = treeGround.m_7494_();
        }
        boolean flag = false;
        BlockPos branchFrom = treeGround;
        for (Direction direction : ACMath.HORIZONTAL_DIRECTIONS) {
            if (!randomsource.m_188499_()) continue;
            int branchLength = randomsource.m_188503_(8) + 8;
            this.buildBranchFrom(level, branchFrom.m_6625_(1 + randomsource.m_188503_(2)), randomsource, branchLength, direction, randomsource.m_188503_(2) == 0, randomsource.m_188499_());
            flag = true;
        }
        if (!flag) {
            int n = randomsource.m_188503_(8) + 8;
            this.buildBranchFrom(level, branchFrom.m_6625_(1 + randomsource.m_188503_(2)), randomsource, n, ACMath.HORIZONTAL_DIRECTIONS[randomsource.m_188503_(3)], randomsource.m_188503_(2) == 0, randomsource.m_188499_());
        }
        return true;
    }

    private void buildBranchFrom(WorldGenLevel level, BlockPos startBranchPos, RandomSource random, int length, Direction originalBranchDirection, boolean spiralUp, boolean propogate) {
        Direction[] directions = spiralUp ? SPIRAL_UP_MAP.get(originalBranchDirection) : SPIRAL_DOWN_MAP.get(originalBranchDirection);
        int currentBranchDirectionOrdinal = 0;
        int i = 0;
        Direction moveDirection = directions[0];
        BlockPos branchPos = startBranchPos.m_121945_(moveDirection);
        int movesInDirection = 0;
        int movesNeededToSpiral = (int)Math.floor((float)length / 4.0f);
        boolean split = false;
        while (i < length && LicorootTreeFeature.canReplace(level.m_8055_(branchPos))) {
            if (propogate && moveDirection.m_122434_().m_122478_() && !split && random.m_188501_() < 0.6f) {
                split = true;
                this.buildBranchFrom(level, branchPos, random, Math.max(2, length - 2), originalBranchDirection, !spiralUp, false);
            }
            int j = movesNeededToSpiral;
            if (currentBranchDirectionOrdinal == 0) {
                ++j;
            }
            if (random.m_188501_() < 0.8f && movesInDirection >= j) {
                movesInDirection = 0;
                currentBranchDirectionOrdinal = (currentBranchDirectionOrdinal + 1) % 4;
                moveDirection = directions[currentBranchDirectionOrdinal];
            } else {
                ++movesInDirection;
                LicorootTreeFeature.dropVinesFrom(level, branchPos, random, 0.8f);
                level.m_7731_(branchPos, (BlockState)((Block)ACBlockRegistry.LICOROOT.get()).m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)moveDirection.m_122434_()), 3);
            }
            if (movesInDirection > 0 && currentBranchDirectionOrdinal > 3) continue;
            ++i;
            branchPos = branchPos.m_121945_(moveDirection);
        }
    }

    private boolean checkCanTreePlace(WorldGenLevel level, BlockPos treeBottom, int height) {
        BlockState below = level.m_8055_(treeBottom.m_7495_());
        if (!(below.m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()) || below.m_60713_((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()) || below.m_60713_((Block)ACBlockRegistry.CAKE_LAYER.get()))) {
            return false;
        }
        for (int i = 0; i < height; ++i) {
            if (LicorootTreeFeature.canReplace(level.m_8055_(treeBottom.m_6630_(i)))) continue;
            return false;
        }
        BlockPos treeTop = treeBottom.m_6630_(height).m_7949_();
        for (BlockPos checkLeaf : BlockPos.m_121940_((BlockPos)treeTop.m_7918_(-2, -1, -2), (BlockPos)treeTop.m_7918_(2, 1, 2))) {
            if (LicorootTreeFeature.canReplace(level.m_8055_(checkLeaf))) continue;
            return false;
        }
        return true;
    }

    protected static void dropVinesFrom(WorldGenLevel level, BlockPos from, RandomSource random, float vineChance) {
        if (random.m_188501_() < vineChance) {
            BlockState vine;
            int i;
            BlockPos vinePos = from.m_7949_().m_121945_(Direction.DOWN);
            int vineLength = 1 + random.m_188503_(4);
            for (i = 0; i < vineLength && level.m_8055_(vinePos).m_247087_(); ++i) {
                vine = (BlockState)((BlockState)((Block)ACBlockRegistry.LICOROOT_VINE.get()).m_49966_().m_61124_((Property)LicorootVineBlock.FACING, (Comparable)Direction.DOWN)).m_61124_((Property)LicorootVineBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(vinePos).m_192917_((Fluid)Fluids.f_76193_)));
                level.m_7731_(vinePos, vine, 3);
                vinePos = vinePos.m_121945_(Direction.DOWN);
            }
            if (i > 0) {
                vine = (BlockState)((BlockState)((BlockState)((Block)ACBlockRegistry.LICOROOT_VINE.get()).m_49966_().m_61124_((Property)LicorootVineBlock.FACING, (Comparable)Direction.DOWN)).m_61124_((Property)LicorootVineBlock.END, (Comparable)Boolean.valueOf(true))).m_61124_((Property)LicorootVineBlock.WATERLOGGED, (Comparable)Boolean.valueOf(level.m_6425_(vinePos).m_192917_((Fluid)Fluids.f_76193_)));
                level.m_7731_(vinePos.m_7494_(), vine, 3);
            }
        }
    }

    private static boolean canReplace(BlockState state) {
        return (state.m_60795_() || state.m_247087_() || state.m_60713_((Block)ACBlockRegistry.LICOROOT_SPROUT.get()) || state.m_204336_(BlockTags.f_144274_) || state.m_60713_((Block)ACBlockRegistry.BLOCK_OF_CHOCOLATE.get()) || state.m_60713_((Block)ACBlockRegistry.BLOCK_OF_FROSTED_CHOCOLATE.get()) || state.m_60713_((Block)ACBlockRegistry.LICOROOT_VINE.get())) && !state.m_204336_(ACTagRegistry.UNMOVEABLE);
    }
}

