/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.connector;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cpw.mods.modlauncher.api.LamdbaExceptionUtils;
import cpw.mods.modlauncher.api.ServiceRunner;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;
import net.minecraftforge.fml.loading.FMLPaths;
import org.jetbrains.annotations.Nullable;
import org.sinytra.connector.locator.EmbeddedDependencies;

public final class ConnectorUtil {
    public static final String FABRIC_MOD_JSON = "fabric.mod.json";
    public static final String MODS_TOML = "META-INF/mods.toml";
    public static final String AT_PATH = "META-INF/accesstransformer.cfg";
    public static final String CONNECTOR_MARKER = "connector_transformed";
    public static final String FORGE_MODID = "forge";
    public static final long ZIP_TIME = 318211200000L;
    public static final Path CONNECTOR_FOLDER = FMLPaths.MODSDIR.get().resolve(".connector");
    public static final String CONNECTOR_MODID = "connectormod";
    public static final String CONNECTOR_ISSUE_TRACKER_URL = "https://github.com/Sinytra/Connector/issues";
    private static final Pattern STRIP_COLOR_PATTERN = Pattern.compile("(?i)\\u00A7[0-9A-FK-OR]");
    public static final Collection<String> DISABLED_MODS = Set.of("fabric_api");
    private static final String MIXINEXTRAS_MODID = "com_github_llamalad7_mixinextras";
    private static final Version MIXINEXTRAS_ENTRYPOINT_VERSION = (Version)LamdbaExceptionUtils.uncheck(() -> Version.parse("0.2.0-beta.6"));
    public static final Collection<String> DISABLED_MIXINEXTRAS_ENTRYPOINTS = Set.of("com.llamalad7.mixinextras.MixinExtrasBootstrap", "com.llamalad7.mixinextras.MixinExtrasBootstrap::init");
    private static final Set<String> RESERVED = Set.of("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while", "true", "false", "null", "_");
    public static final Multimap<String, String> DEFAULT_GLOBAL_MOD_ALIASES = ImmutableMultimap.of((Object)"cloth_config", (Object)"cloth-config2", (Object)"playeranimator", (Object)"player-animator");
    private static final boolean CACHE_ENABLED;

    public static CacheFile getCached(@Nullable Path input, Path output) {
        if (CACHE_ENABLED) {
            Path inputCache = output.getParent().resolve(output.getFileName() + ".input");
            try {
                Object hash = EmbeddedDependencies.getJarCacheVersion();
                if (input != null) {
                    byte[] bytes = Files.readAllBytes(input);
                    hash = (String)hash + "," + Hashing.sha256().hashBytes(bytes);
                }
                if (Files.exists(inputCache, new LinkOption[0])) {
                    if (Files.exists(output, new LinkOption[0])) {
                        String cached = Files.readString(inputCache);
                        if (cached.equals(hash)) {
                            return new CacheFile(inputCache, (String)hash, true);
                        }
                        Files.delete(output);
                        Files.delete(inputCache);
                    }
                } else {
                    Files.deleteIfExists(output);
                }
                return new CacheFile(inputCache, (String)hash, false);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return new CacheFile(null, null, false);
    }

    public static void cache(@Nullable Path input, Path output, ServiceRunner action) {
        CacheFile cacheFile = ConnectorUtil.getCached(input, output);
        if (!cacheFile.isUpToDate()) {
            try {
                Files.deleteIfExists(output);
                action.run();
                cacheFile.save();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
    }

    public static boolean isJavaReservedKeyword(String str) {
        return RESERVED.contains(str);
    }

    public static Gson prettyGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    public static <V> V uncheckThrowable(UncheckedSupplier<V> supplier) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static String stripColor(String str) {
        return str != null ? STRIP_COLOR_PATTERN.matcher(str).replaceAll("") : null;
    }

    public static List<EntrypointMetadata> filterMixinExtrasEntrypoints(List<EntrypointMetadata> entrypoints) {
        return FabricLoader.getInstance().getModContainer(MIXINEXTRAS_MODID).filter(mod -> mod.getMetadata().getVersion().compareTo(MIXINEXTRAS_ENTRYPOINT_VERSION) >= 0).map(mod -> entrypoints.stream().filter(metadata -> !DISABLED_MIXINEXTRAS_ENTRYPOINTS.contains(metadata.getValue())).toList()).orElse(entrypoints);
    }

    private ConnectorUtil() {
    }

    static {
        String prop = System.getProperty("connector.cache.enabled");
        CACHE_ENABLED = prop == null || prop.equals("true");
    }

    public static class CacheFile {
        private final Path inputCache;
        private final String inputChecksum;
        private boolean isUpToDate;

        public CacheFile(Path inputCache, String inputChecksum, boolean isUpToDate) {
            this.inputCache = inputCache;
            this.inputChecksum = inputChecksum;
            this.isUpToDate = isUpToDate;
        }

        public boolean isUpToDate() {
            return this.isUpToDate;
        }

        public void save() {
            if (this.inputCache != null) {
                try {
                    Files.writeString(this.inputCache, (CharSequence)this.inputChecksum, new OpenOption[0]);
                    this.isUpToDate = true;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface UncheckedSupplier<V> {
        public V get() throws Throwable;
    }
}

