/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import me.pepperbell.continuity.client.mixinterface.ModelLoaderExtension;
import me.pepperbell.continuity.client.model.QuadProcessors;
import me.pepperbell.continuity.client.resource.CtmPropertiesLoader;
import me.pepperbell.continuity.client.resource.EmissiveSuffixLoader;
import me.pepperbell.continuity.client.resource.ModelWrappingHandler;
import me.pepperbell.continuity.client.resource.SpriteLoaderLoadContext;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4724;
import org.jetbrains.annotations.Nullable;

public class BakedModelManagerReloadExtension {
    private final CompletableFuture<CtmPropertiesLoader.LoadingResult> ctmLoadingResultFuture;
    private final AtomicBoolean wrapEmissiveModels = new AtomicBoolean();
    private final SpriteLoaderLoadContextImpl spriteLoaderLoadContext;
    private volatile List<QuadProcessors.ProcessorHolder> processorHolders;

    public BakedModelManagerReloadExtension(class_3300 resourceManager, Executor prepareExecutor) {
        this.ctmLoadingResultFuture = CompletableFuture.supplyAsync(() -> CtmPropertiesLoader.loadAllWithState(resourceManager), prepareExecutor);
        this.spriteLoaderLoadContext = new SpriteLoaderLoadContextImpl((CompletableFuture<Map<class_2960, Set<class_2960>>>)this.ctmLoadingResultFuture.thenApply(CtmPropertiesLoader.LoadingResult::getTextureDependencies), this.wrapEmissiveModels);
        EmissiveSuffixLoader.load(resourceManager);
    }

    public void setContext() {
        SpriteLoaderLoadContext.THREAD_LOCAL.set(this.spriteLoaderLoadContext);
    }

    public void clearContext() {
        SpriteLoaderLoadContext.THREAD_LOCAL.set(null);
    }

    public void beforeBaking(Map<class_2960, class_4724.class_7774> preparations, class_1088 modelLoader) {
        CtmPropertiesLoader.LoadingResult result = this.ctmLoadingResultFuture.join();
        List<QuadProcessors.ProcessorHolder> processorHolders = result.createProcessorHolders(spriteId -> {
            class_4724.class_7774 preparation = (class_4724.class_7774)preparations.get(spriteId.method_24144());
            class_1058 sprite = preparation.method_45869(spriteId.method_24147());
            if (sprite != null) {
                return sprite;
            }
            return preparation.method_45868();
        });
        this.processorHolders = processorHolders;
        ModelWrappingHandler wrappingHandler = ModelWrappingHandler.create(!processorHolders.isEmpty(), this.wrapEmissiveModels.get());
        ((ModelLoaderExtension)modelLoader).continuity$setModelWrappingHandler(wrappingHandler);
    }

    public void apply() {
        List<QuadProcessors.ProcessorHolder> processorHolders = this.processorHolders;
        if (processorHolders != null) {
            QuadProcessors.reload(processorHolders);
        }
    }

    private static class SpriteLoaderLoadContextImpl
    implements SpriteLoaderLoadContext {
        private final CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture;
        private final Map<class_2960, CompletableFuture<Set<class_2960>>> extraIdsFutures = new Object2ObjectOpenHashMap();
        private final SpriteLoaderLoadContext.EmissiveControl blockAtlasEmissiveControl;

        public SpriteLoaderLoadContextImpl(CompletableFuture<Map<class_2960, Set<class_2960>>> allExtraIdsFuture, AtomicBoolean blockAtlasHasEmissivesHolder) {
            this.allExtraIdsFuture = allExtraIdsFuture;
            this.blockAtlasEmissiveControl = new EmissiveControlImpl(blockAtlasHasEmissivesHolder);
        }

        @Override
        public CompletableFuture<@Nullable Set<class_2960>> getExtraIdsFuture(class_2960 atlasId) {
            return this.extraIdsFutures.computeIfAbsent(atlasId, id -> this.allExtraIdsFuture.thenApply(allExtraIds -> (Set)allExtraIds.get(id)));
        }

        @Override
        @Nullable
        public SpriteLoaderLoadContext.EmissiveControl getEmissiveControl(class_2960 atlasId) {
            if (atlasId.equals((Object)class_1059.field_5275)) {
                return this.blockAtlasEmissiveControl;
            }
            return null;
        }

        private static class EmissiveControlImpl
        implements SpriteLoaderLoadContext.EmissiveControl {
            @Nullable
            private volatile Map<class_2960, class_2960> emissiveIdMap;
            private final AtomicBoolean hasEmissivesHolder;

            public EmissiveControlImpl(AtomicBoolean hasEmissivesHolder) {
                this.hasEmissivesHolder = hasEmissivesHolder;
            }

            @Override
            @Nullable
            public Map<class_2960, class_2960> getEmissiveIdMap() {
                return this.emissiveIdMap;
            }

            @Override
            public void setEmissiveIdMap(Map<class_2960, class_2960> emissiveIdMap) {
                this.emissiveIdMap = emissiveIdMap;
            }

            @Override
            public void markHasEmissives() {
                this.hasEmissivesHolder.set(true);
            }
        }
    }
}

