/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import com.google.common.collect.ImmutableMap;
import me.pepperbell.continuity.client.mixinterface.ModelLoaderExtension;
import me.pepperbell.continuity.client.model.CtmBakedModel;
import me.pepperbell.continuity.client.model.EmissiveBakedModel;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelModifier;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_773;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ModelWrappingHandler {
    private final boolean wrapCtm;
    private final boolean wrapEmissive;
    private final ImmutableMap<class_1091, class_2680> blockStateModelIds;

    private ModelWrappingHandler(boolean wrapCtm, boolean wrapEmissive) {
        this.wrapCtm = wrapCtm;
        this.wrapEmissive = wrapEmissive;
        this.blockStateModelIds = ModelWrappingHandler.createBlockStateModelIdMap();
    }

    @Nullable
    public static ModelWrappingHandler create(boolean wrapCtm, boolean wrapEmissive) {
        if (!wrapCtm && !wrapEmissive) {
            return null;
        }
        return new ModelWrappingHandler(wrapCtm, wrapEmissive);
    }

    private static ImmutableMap<class_1091, class_2680> createBlockStateModelIdMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (class_2248 block : class_7923.field_41175) {
            class_2960 blockId = block.method_40142().method_40237().method_29177();
            for (class_2680 state : block.method_9595().method_11662()) {
                class_1091 modelId = class_773.method_3336((class_2960)blockId, (class_2680)state);
                builder.put((Object)modelId, (Object)state);
            }
        }
        return builder.build();
    }

    public class_1087 wrap(@Nullable class_1087 model, class_2960 modelId) {
        if (model != null && !model.method_4713() && !modelId.equals((Object)class_1088.field_5374)) {
            class_2680 state;
            if (this.wrapCtm && modelId instanceof class_1091 && (state = (class_2680)this.blockStateModelIds.get((Object)modelId)) != null) {
                model = new CtmBakedModel((class_1087)model, state);
            }
            if (this.wrapEmissive) {
                model = new EmissiveBakedModel((class_1087)model);
            }
        }
        return model;
    }

    @ApiStatus.Internal
    public static void init() {
        ModelLoadingPlugin.register(pluginCtx -> pluginCtx.modifyModelAfterBake().register(ModelModifier.WRAP_LAST_PHASE, (model, ctx) -> {
            class_1088 modelLoader = ctx.loader();
            ModelWrappingHandler wrappingHandler = ((ModelLoaderExtension)modelLoader).continuity$getModelWrappingHandler();
            if (wrappingHandler != null) {
                return wrappingHandler.wrap(model, ctx.id());
            }
            return model;
        }));
    }
}

