/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common;

import com.electronwill.nightconfig.core.Config;
import com.google.common.collect.ImmutableList;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import io.github.edwinmindcraft.apoli.api.registry.ApoliDynamicRegistries;
import io.github.edwinmindcraft.calio.api.registry.ICalioDynamicRegistryManager;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class OriginsConfigs {
    public static final ForgeConfigSpec COMMON_SPECS;
    public static final ForgeConfigSpec CLIENT_SPECS;
    public static final ForgeConfigSpec SERVER_SPECS;
    public static final Common COMMON;
    public static final Client CLIENT;
    public static final Server SERVER;

    static {
        Pair common = new ForgeConfigSpec.Builder().configure(Common::new);
        Pair client = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair server = new ForgeConfigSpec.Builder().configure(Server::new);
        COMMON_SPECS = (ForgeConfigSpec)common.getRight();
        CLIENT_SPECS = (ForgeConfigSpec)client.getRight();
        SERVER_SPECS = (ForgeConfigSpec)server.getRight();
        COMMON = (Common)common.getLeft();
        CLIENT = (Client)client.getLeft();
        SERVER = (Server)server.getLeft();
    }

    public static class Common {
        private final ForgeConfigSpec.ConfigValue<Config> origins;

        public Common(ForgeConfigSpec.Builder builder) {
            this.origins = builder.define((List)ImmutableList.of((Object)"origins"), Config::inMemory, x -> x instanceof Config, Config.class);
        }

        public boolean isOriginEnabled(ResourceLocation origin) {
            return (Boolean)((Config)this.origins.get()).getOrElse((List)ImmutableList.of((Object)origin.toString(), (Object)"enabled"), (Object)true);
        }

        public boolean isPowerEnabled(ResourceLocation origin, ResourceLocation power) {
            return (Boolean)((Config)this.origins.get()).getOrElse((List)ImmutableList.of((Object)origin.toString(), (Object)power.toString()), (Object)true);
        }

        public boolean updateOriginList(ICalioDynamicRegistryManager registryManager, Iterable<Origin> origins) {
            boolean changed = false;
            MappedRegistry registry = registryManager.get(OriginsDynamicRegistries.ORIGINS_REGISTRY);
            MappedRegistry powers = registryManager.get(ApoliDynamicRegistries.CONFIGURED_POWER_KEY);
            for (Origin origin : origins) {
                ResourceLocation registryName = registry.m_7981_((Object)origin);
                if (origin.isSpecial() || registryName == null) continue;
                if (((Config)this.origins.get()).add((List)ImmutableList.of((Object)registryName.toString(), (Object)"enabled"), (Object)true)) {
                    changed = true;
                }
                for (Holder<ConfiguredPower<?, ?>> holder : origin.getValidPowers().toList()) {
                    Optional key = (Optional)holder.m_203439_().map(Optional::of, arg_0 -> ((WritableRegistry)powers).m_7854_(arg_0));
                    if (!key.isPresent() || !((Config)this.origins.get()).add((List)ImmutableList.of((Object)registryName.toString(), (Object)((ResourceKey)key.get()).m_135782_().toString()), (Object)true)) continue;
                    changed = true;
                }
            }
            return changed;
        }
    }

    public static class Client {
        public Client(ForgeConfigSpec.Builder builder) {
        }
    }

    public static class Server {
        public Server(ForgeConfigSpec.Builder builder) {
        }
    }
}

