/*
 * Decompiled with CFR 0.152.
 */
package io.github.edwinmindcraft.origins.common.network;

import io.github.apace100.origins.Origins;
import io.github.edwinmindcraft.origins.api.OriginsAPI;
import io.github.edwinmindcraft.origins.api.capabilities.IOriginContainer;
import io.github.edwinmindcraft.origins.api.origin.Origin;
import io.github.edwinmindcraft.origins.api.origin.OriginLayer;
import io.github.edwinmindcraft.origins.api.registry.OriginsDynamicRegistries;
import io.github.edwinmindcraft.origins.common.OriginsCommon;
import io.github.edwinmindcraft.origins.common.network.S2CConfirmOrigin;
import io.github.edwinmindcraft.origins.common.registry.OriginRegisters;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record C2SChooseOrigin(ResourceLocation layer, ResourceLocation origin) {
    public static C2SChooseOrigin decode(FriendlyByteBuf buf) {
        return new C2SChooseOrigin(buf.m_130281_(), buf.m_130281_());
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.layer());
        buf.m_130085_(this.origin());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            ServerPlayer sender = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (sender == null) {
                return;
            }
            IOriginContainer.get((Entity)sender).ifPresent(container -> {
                Optional<Holder.Reference> layer = OriginsAPI.getLayersRegistry().m_203636_(ResourceKey.m_135785_(OriginsDynamicRegistries.LAYERS_REGISTRY, (ResourceLocation)this.layer())).filter(Holder::m_203633_);
                if (layer.isEmpty()) {
                    Origins.LOGGER.warn("Player {} tried to select an origin for missing layer {}", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                if (container.hasAllOrigins() || container.hasOrigin((Holder<OriginLayer>)((Holder)layer.get()))) {
                    Origins.LOGGER.warn("Player {} tried to choose origin for layer {} while having one already.", (Object)sender.m_6302_(), (Object)this.layer());
                    return;
                }
                Optional<Holder.Reference> origin = OriginsAPI.getOriginsRegistry().m_203636_(ResourceKey.m_135785_(OriginsDynamicRegistries.ORIGINS_REGISTRY, (ResourceLocation)this.origin())).filter(Holder::m_203633_);
                if (origin.isEmpty()) {
                    Origins.LOGGER.warn("Player {} chose unknown origin: {} for layer {}", (Object)sender.m_6302_(), (Object)this.origin(), (Object)this.layer());
                    return;
                }
                if (!((Origin)origin.get().m_203334_()).isChoosable() || !((OriginLayer)layer.get().m_203334_()).contains(this.origin(), (Player)sender)) {
                    Origins.LOGGER.warn("Player {} tried to choose invalid origin: {} for layer: {}", (Object)sender.m_6302_(), (Object)this.origin(), (Object)this.layer());
                    container.setOrigin((Holder<OriginLayer>)((Holder)layer.get()), (Holder<Origin>)((Holder)OriginRegisters.EMPTY.getHolder().orElseThrow()));
                } else {
                    boolean hadOriginBefore = container.hadAllOrigins();
                    boolean hadAllOrigins = container.hasAllOrigins();
                    container.setOrigin((Holder<OriginLayer>)((Holder)layer.get()), (Holder<Origin>)((Holder)origin.get()));
                    container.checkAutoChoosingLayers(false);
                    if (container.hasAllOrigins() && !hadAllOrigins) {
                        container.onChosen(hadOriginBefore);
                    }
                }
                container.synchronize();
                OriginsCommon.CHANNEL.send(PacketDistributor.PLAYER.with(() -> sender), (Object)new S2CConfirmOrigin(this.layer(), this.origin()));
            });
        });
        contextSupplier.get().setPacketHandled(true);
    }
}

